<?php
ini_set('display_errors', 1);
require_once(__DIR__ . '/../includes/functions.php');


$tableNames = ['app_dns', 'app_image', 'api_key', 'themes'];
$configurations = [];

foreach ($tableNames as $tableName) {
    $rows = $db->select($tableName);
    foreach ($rows as $row) {
        if (!isset($configurations[$tableName])) {
            $configurations[$tableName] = [];
        }
        $configurations[$tableName][] = $row; 
    }
}

$jsonFilePath = __DIR__ . '/config.json'; 

if (file_exists($jsonFilePath)) {
    $jsonString = file_get_contents($jsonFilePath);
    $configArray = json_decode($jsonString, true);
} else {
    $configArray = []; 
}

foreach ($configurations as $key => $value) {
    if (!empty($value)) {
        $configArray[$key] = $value;
    }
}

$jsonString = json_encode($configArray, JSON_PRETTY_PRINT);

for ($i = 0; $i < 4; $i++) {
    $jsonString = base64_encode($jsonString);
}

echo $jsonString;
